Imports System.Drawing

'
' Instances of this class represent a character in a document.
'
Public Class DocChar
    Implements IDocumentElement

    Private myParent As CompositeDocumentElement
    ' object's parent
    Public Property Parent() As CompositeDocumentElement _
     Implements IDocumentElement.Parent
        Get
            Return myParent
        End Get
        Set(ByVal Value As CompositeDocumentElement)
            myParent = Value
        End Set
    End Property

    Private myFont As Font
    ' font
    Public Property Font() As Font _
     Implements IDocumentElement.Font
        Get
            Return myFont
        End Get
        Set(ByVal Value As Font)
            myFont = Value
        End Set
    End Property

    ' the number of characters that this object contains
    Public ReadOnly Property CharLength() As Integer _
     Implements IDocumentElement.CharLength
        Get
            Return 1
        End Get
    End Property

    ' style
    Public Property Style() As String _
     Implements IDocumentElement.Style
        Get
            Return "Fixed"
        End Get
        Set(ByVal Value As String)
            Throw New System.ApplicationException("Cannot set style on DocChar")
        End Set
    End Property
End Class 'DocChar
